/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* -----------------------------------------------------------------------
 * File: host.h
 * Author: Joerg Striegel 4.6.96
 * Purpose: This file contains the function prototypes for upload and
 * download functions between host/files and system/internal memory 
 * ----------------------------------------------------------------------- */

#ifndef HOST_H_INCLUDED
#define HOST_H_INCLUDED

#include <propdefs.h>
#include <hostdefs.h>

#define MASTER_BUFFER_DW_COUNT 127
#define INTERNAL_MEM_DW_SIZE   0x8000

/* verify flag for sysmemfill functions. Will be or'd to command */
CLI				/* DEF_START ~G_HostAccess */
#define B_HOST_VERIFY 0x100	/* @verify */
CLI				/* DEF_END */


#ifdef __cplusplus
extern "C" {
#endif

CLI b_errtype EXPORT BestDataMemInit(                         /* @dataminit */
				    b_handletype handle
				    );

CLI b_errtype EXPORT BestDataMemWrite(                         /* @datamwr */
				    b_handletype handle,
				    b_int32    int_addr,       /* @iad */
				    b_int32    num_of_bytes,   /* @nob */
				    b_int8 HUGE * data_ptr     /* @data */
				    );
  
CLI b_errtype EXPORT BestDataMemRead(                         /* @datamrd */
				    b_handletype handle,
				    b_int32     int_addr,           /* @iad */
				    b_int32     num_of_bytes,       /* @nob */
				    b_int8 HUGE * data_ptr    /* @data #RETURN intelhexdump(data_ptr,num_of_bytes,cmd,NULL,NULL) [num_of_bytes] */
				    );

CLI b_errtype EXPORT BestDataMemPatternFill(                  /* @datampfill */
				    b_handletype handle,
				    b_int32     int_addr,     /* @iad */
				    b_int32     num_of_bytes, /* @nob */
				    b_int32     value1,       /* @val1 */
				    b_int32     value2,       /* @val2 */
                                    b_dmempatttype  pattern       /* @patt */
				    );




CLI b_errtype EXPORT BestHostIntMemFill(                         /* @himfill */
				    b_handletype handle,
				    b_int32     int_addr,           /* @iad */
				    b_int32     num_of_bytes,       /* @nob */
				    b_int8 HUGE * data_ptr      /* @data */
				    );
  
CLI b_errtype EXPORT BestHostIntMemDump(                         /* @himdump */
				    b_handletype handle,
				    b_int32     int_addr,           /* @iad */
				    b_int32     num_of_bytes,       /* @nob */
				    b_int8 HUGE * data_ptr    /* @data #RETURN intelhexdump(data_ptr,num_of_bytes,cmd,NULL,NULL) [num_of_bytes] */
				    );
  

CLI b_errtype EXPORT BestHostSysMemAccessPrepare(               /* @hsmaprep */
					     b_handletype handle, 
					     b_int32      buscmd,  /* @cmd */
					     b_int32      bufsize  /* @buf */
					     );

  
CLI b_errtype EXPORT BestHostSysMemFill(                        /* @hsmfill  */
				    b_handletype handle,
				    b_int32    bus_addr,    /* @bad */
				    b_int32    num_of_bytes, /* @nob */
				    b_int32    blocksize,        /* @blk */
				    b_int8 HUGE * data_ptr    /* @data */
				    );

CLI b_errtype EXPORT BestHostSysMemDump(                       /* @hsmdump */
				    b_handletype handle,
				    b_int32    bus_addr,  /* @bad */
				    b_int32    num_of_bytes,  /* @nob */
				    b_int32    blocksize,  /* @blk */
				    b_int8 HUGE * data_ptr    /* @data #RETURN intelhexdump(data_ptr,num_of_bytes,cmd,NULL,NULL) [num_of_bytes] */
				    );

CLI b_errtype EXPORT BestHostSysMemFill64(                      /* @hsmfill64 */
                  b_handletype handle,
                  b_int32 bus_addr_low,   /* @badl */
                  b_int32 bus_addr_high,  /* @badh */
                  b_int32 num_of_bytes,    /* @nob */
                  b_int32 blocksize,      /* @blk */
                  b_int8 HUGE * data_ptr  /* @data */
                  );

CLI b_errtype EXPORT BestHostSysMemDump64(                      /* @hsmdump64 */
                  b_handletype handle,
                  b_int32 bus_addr_low,   /* @badl */
                  b_int32 bus_addr_high,  /* @badh */
                  b_int32 num_of_bytes,    /* @nob */
                  b_int32 blocksize,      /* @blk */
                  b_int8 HUGE * data_ptr  /* @data #RETURN intelhexdump(data_ptr,num_of_bytes,cmd,NULL,NULL) [num_of_bytes] */
                  );

  
CLI  b_errtype EXPORT BestHostPCIRegSet(                        /* @hprgset */
		              b_handletype    handle,
		              b_addrspacetype addrspace,      /* @space */
		              b_int32         bus_addr,       /* @bad */
		              b_int32         reg_value,      /* @val */
 	                b_sizetype      wordsize        /* @size */
		              );
  
  
  
CLI  b_errtype EXPORT BestHostPCIRegGet(                       /* @hprgget */
		              b_handletype    handle,
		              b_addrspacetype addrspace,      /* @space */
		              b_int32         bus_addr,       /* @bad */
		              b_int32         *regvalue_ptr,  /* #RETURN "value =: %08lx\n" */
		              b_sizetype      wordsize        /* @size */
		              );



#ifdef __cplusplus
}
#endif

#endif





